#include <stdio.h>
#include <stdlib.h>
#include "help.h"
#include "variables.h"
#include "finddir.h"

void help() {
	printf("\n");
	printf("\t./conky-colors <options>\n\n");
	printf("\toptions:\n");
	printf("\t-------------- LANGUAGES --------------\n");
	printf("\t--lang=<language> - Set default language\n");
	printf("\tLanguages: bg|de|el|en*|et|fr|it|pl|pt|ru|es|uk\n");
	printf("\t-------------- THEMES --------------\n");
	printf("\t--theme=<theme> - Set default theme color\n");
	printf("\tThemes: brave|carbonite|dust|human*|noble|tribute|wine|wise|\n");
	printf("\t        ambiance|radiance|elementary|\n");
	printf("\t        cyan|blue|orange|red|green|purple|black|white|\n");
	printf("\t        custom\n");
	printf("\tWork only with --theme=custom\n");
	printf("\t\t--default-color=<value>\n");
	printf("\t\t--color0=<value>\n");
	printf("\t\t--color1=<value>\n");
	printf("\t\t--color2=<value>\n");
	printf("\t\t--color3=<value>\n");
	printf("\t--dark - Set Dark Brightness\n");
	printf("\t-------------- DEFAULT MODE --------------\n");
	printf("\t--<logo> - Replace computer icon for distro Logo\n");
	printf("\tLogos: ubuntu|fedora|opensuse|debian|arch|gentoo|pardus|xfce|gnome\n");
	printf("\t--cpu=<number> - Set number of cpu cores\n");
	printf("\t--cputemp - Enable CPU temperature\n");
	printf("\t--swap - Enable SWAP\n");
	printf("\t--battery - Enable battery\n");
	printf("\t--battery-value=<number> - Change battery device number </proc/acpi/battery>\n");
	printf("\t--updates - Show updates for Debian/Ubuntu\n");
	printf("\t--proc=<number> - Enable processes [Max = 10]\n");
	printf("\t--clock=<default|modern|digital|off>\n");
	printf("\t--nodata - disable Data\n");
	printf("\t--calendar - Enable calendar\n");
	printf("\t--calendarm - Enable calendar with monday as first day\n");
	printf("\t--calendarzim - Enable calendar with Zim support\n");
	printf("\t--nvidia - Enable nvidia gpu\n");
	printf("\t--task - Enable Task [type \"ct help\" in terminal for info]\n");
	printf("\t--hd=<default|meerkat|mix|simple> - Enable HD\n");
	printf("\t--hdtemp1=<device> - Enable HD temperature [Ex: --hdtemp1=sda]\n");
	printf("\t--hdtemp2=<device> - Enable HD temperature [Ex: --hdtemp2=sdb]\n");
	printf("\t--hdtemp3=<device> - Enable HD temperature [Ex: --hdtemp3=sdc]\n");
	printf("\t--hdtemp4=<device> - Enable HD temperature [Ex: --hdtemp4=sdd]\n");
	printf("\t--photo - Enable Photo\n");
	printf("\t--photord - Enable Photo in random mode\n");
	printf("\t--mpd - Enable MPD\n");
	printf("\t--banshee=<default|cd|case|glassy|vinyl|oldvinyl|simple>\n");
	printf("\t--clementine=<default|cd|case|glassy|vinyl|oldvinyl|simple>\n");
	printf("\t--rhythmbox=<default|cd|case|glassy|vinyl|oldvinyl|simple>\n");
	printf("\t--covergloobus - Enable CoverGloobus\n");
	printf("\t--gmail - Enable gmail notify\n");
	printf("\t\t--user=<username> - Type your username\n");
	printf("\t\t--passwd=<password> - Type your password\n");
	printf("\t--network - Enable network\n");
	printf("\t\t--eth=<number> - Change ethernet device [Default=0]\n");
	printf("\t\t--wlan=<number> - Change wireless device [Default=0]\n");
	printf("\t\t--ppp=<number> - Change 3g modem device [Default=0]\n");
	printf("\t--unit=<C|F>- Force output temperature either in Celius or Fahrenheit\n");
	printf("\t--weather=<AreaID> - Enable weather[Ex: --weather=BRXX0043]\n");
	printf("\t--bbcweather=<AreaID> - Enable weather[Ex: --bbcweather=3849]\n");
	printf("\t--side=<left|right*> - Set the side of conky in your screem\n");
	printf("\t-------------- CAIRO/RING MODE --------------\n");
	printf("\t--cairo - Enable cairo-conky mode.\n");
	printf("\t--ring - Enable ring-conky mode.\n");
	printf("\t--cpu=<number> - Set number of cpu cores\n");
	printf("\t--swap - Enable SWAP [cairo-mode only]\n");
	printf("\t--clock=<cairo|bigcairo> - Enable/disable clock [cairo-mode only]\n");
	printf("\t--banshee=<cairo|cairo-case|cairo-cd|cairo-glassy|lua> [cairo-mode only]\n");
	printf("\t--clementine=<cairo|cairo-case|cairo-cd|cairo-glassy|lua> [cairo-mode only]\n");
	printf("\t--rhythmbox=<cairo|cairo-case|cairo-cd|cairo-glassy|lua> [cairo-mode only]\n");
	printf("\t--banshee=<ring|ring-case|ring-cd|ring-glassy> [ring-mode only]\n");
	printf("\t--clementine=<ring|ring-case|ring-cd|ring-glassy> [ring-mode only]\n");
	printf("\t--rhythmbox=<ring|ring-case|ring-cd|ring-glassy> [ring-mode only]\n");
	printf("\t--network - Enable network\n");
	printf("\t--unit=<C|F>- Force output temperature either in Celius or Fahrenheit\n");
	printf("\t-------------- BOARD/SLIM MODE --------------\n");
	printf("\t--board - Enable board-conky mode.\n");
	printf("\t--slim - Enable slim-conky mode.\n");
	printf("\t--w=<width> - Set your screen width\n");
	printf("\t--h=<height> - Set your screen height\n");
	printf("\t--nobg - Remove background\n");
	printf("\t--posfix=<number> - fix ring position\n");
	printf("\t--weather=<AreaID> - Enable weather[Ex: --weather=BRXX0043]\n");
	printf("\t--unit=<C|F>- Force output temperature either in Celius or Fahrenheit\n");
	printf("\t-------------- SLS MODE --------------\n");
	printf("\t--sls - Enable SLS-conky mode.\n");
	printf("\t--nobg - Remove background\n");
	printf("\t--weather=<AreaID> - Enable weather[Ex: --weather=BRXX0043]\n");
	printf("\t--user=<username> - Type your gmail username\n");
	printf("\t--passwd=<password> - Type your gmail password\n");
	printf("\t-------------- EXTRA OPTIONS --------------\n");
	printf("\t--datadir=/path/to/datadir - it overrides default datadir\n");
	printf("\t--createlocalcopy - it copies the content of system datadir to %s\n", localdir());
	printf("\t--nofilecheck - disables checking the presence of files\n");
	printf("\t--default_datadir - prints the order of default datadirs in which files are searched by default.\n");
	printf("\t--finddir=FILE - this option makes this program find and print out a directory where FILE is located.\n");
	printf("\t--argb-value=0-255 - Set the value of own_window_argb_value, the default is %d\n", ARGB_VALUE);
	printf("\t--install=local(*), system, or custom - install generated configuration files to a chosen datadir.\n");
	printf("\t--systemdir - displays the system directory for conkycolors.\n");
	printf("\t--localdir - displays the local directory for conkycolors.\n");
	printf("\t\n(*)default values\n\n");
}
