{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetPlane: TVector4;
    procedure SetPlane(const Value: TVector4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdPlane: TSFVec4f;
    { Internal wrapper for property @code(Plane). This wrapper API may change, we advise to access simpler @code(Plane) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPlane: TSFVec4f read FFdPlane;
    {  }
    property Plane: TVector4 read GetPlane write SetPlane;

{$endif read_interface}

{$ifdef read_implementation}

{ TClipPlaneNode ----------------------------------------------- }

function TClipPlaneNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TClipPlaneNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TClipPlaneNode.GetPlane: TVector4;
begin
  Result := FdPlane.Value;
end;

procedure TClipPlaneNode.SetPlane(const Value: TVector4);
begin
  FdPlane.Send(Value);
end;

class function TClipPlaneNode.ClassX3DType: String;
begin
  Result := 'ClipPlane';
end;

procedure TClipPlaneNode.CreateNode;
begin
  inherited;

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chClipPlane;
  AddField(FFdEnabled);

  FFdPlane := TSFVec4f.Create(Self, True, 'plane', Vector4(0, 1, 0, 0));
   FdPlane.ChangeAlways := chClipPlane;
  AddField(FFdPlane);
end;

{$endif read_implementation}
